package com.agilex.healthcare.directscheduling.mdws.connection;


import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.UUID;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SchedulingSvc;
import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SchedulingSvcSoap;
import com.agilex.healthcare.directscheduling.validator.MdwsResponseException;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


@Component
public class SchedulingConnection implements Serializable {

    private static final long serialVersionUID = -978507159875320587L;

    private String id;
    private MdwsConfiguration configuration;
    private SchedulingSvcSoap port;
    private Date refreshedTimestamp;

    public SchedulingConnection() {
        this.id = UUID.randomUUID().toString();
    }

    public SchedulingConnection(SchedulingSvcSoap port) {
        this.id = UUID.randomUUID().toString();
        this.port = port;
    }


    public SchedulingConnection(MdwsConfiguration configuration) {
        this.id = UUID.randomUUID().toString();
        this.configuration = configuration;
        this.port = establishConnection(configuration);
        this.refreshedTimestamp = new Date();
    }

    private SchedulingSvcSoap establishConnection(MdwsConfiguration configuration) {
        String baseUrl = "";

        baseUrl = configuration.getEndPointBaseUrl();
        configuration.setEndPointBaseUrl(baseUrl);

   		String url = baseUrl + configuration.getEndPointUrl();

    	URL wsdlLocation = constructWsdlUrl(url);
        SchedulingSvc schedulingSvc = null;
        try {
        	schedulingSvc = new SchedulingSvc(wsdlLocation, new QName("http://DNS        /SchedulingSvc", "SchedulingSvc"));
        } catch (Throwable t) {
			throw new MdwsResponseException(MdwsResponseException.UserMessages.CONNECTION_ERROR, t.getMessage());
		}
        SchedulingSvcSoap port = schedulingSvc.getSchedulingSvcSoap();

        Client client = ClientProxy.getClient(port);
        HTTPConduit http = (HTTPConduit) client.getConduit();

        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();

        httpClientPolicy.setConnectionTimeout(configuration.getWsConnectTimeout());
        httpClientPolicy.setAllowChunking(false);
        httpClientPolicy.setReceiveTimeout(configuration.getWsRequestTimeout());

        http.setClient(httpClientPolicy);

    	((BindingProvider)port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, url);

        return port;
    }

    private URL constructWsdlUrl(String endPointUrl){
        String wsdlLocation = endPointUrl + "?WSDL";
        URL wsdlLocationURL = null;
        try {
            wsdlLocationURL = new URL(wsdlLocation);
        } catch (Exception e) {
        	throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_WSDL, e.getMessage());
        }

        return wsdlLocationURL;
    }

    public Date getRefreshedTimestamp() {
        return refreshedTimestamp;
    }

    public void refreshTimestamp() {
        this.refreshedTimestamp = new Date();
    }

    public String getId() {
        return id;
    }

    public SchedulingSvcSoap getPort() {
        return port;
    }

    public MdwsConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SchedulingConnection other = (SchedulingConnection) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        return true;
    }
}
